<?php
/*
* 2007-2010 PrestaShop 
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Prestashop SA <contact@prestashop.com>
*  @copyright  2007-2010 Prestashop SA
*  @version  Release: $Revision: 1.4 $
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

/*
* 2011 PrestaShop Gurkcity Edition 
*
* NOTICE OF LICENSE
*
* This source file is a modified version of the original file created by Prestashop SA
*
* This source file is subject to the Open Software License (OSL 3.0)
* It is available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
*
*  @author    Gurkcity <prestasho@gurkcity.de>
*  @copyright 2011 Gurkcity
*  @version   1.4 GC Edition
*  @license   http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class GCInvoice extends PaymentModule {
	
	/*
	*	Construct / Destruct
	*/
	
	public function __construct() {
		
		$this->name    = 'gcinvoice';
		$this->tab     = 'payments_gateways';
		$this->version = '1.4.3.0';
		$this->author  = 'Onlineshop-Module.de';
		
		parent::__construct();

		$this->displayName = $this->l('Invoice');
		$this->description = $this->l('Accept payments by invoice');
		
	}
	
	/*
	*	Install / Uninstall
	*/
	
	public function install() {
		
		if (
			   !parent::install() 
			OR !$this->registerHook('payment') 
			OR !$this->registerHook('paymentReturn')
		) {
			return false;
		}
		
		Configuration::updateValue('GC_INVOICE_MAX_VALUE', 100.0);
		
		if (!Configuration::get('GC_INVOICE_OS')) {
			
			$orderState = new OrderState();
			$orderState->name = array();
			foreach (Language::getLanguages() AS $language) {
				$orderState->name[$language['id_lang']] = 'paid with invoice';
			}
			$orderState->send_email = false;
			$orderState->color = '#DDEEFF';
			$orderState->hidden = false;
			$orderState->delivery = false;
			$orderState->logable = true;
			$orderState->unremovable = true;
			$orderState->invoice = true;
			
			if ($orderState->add())
				copy(dirname(__FILE__).'/img/os_invoice.gif', dirname(__FILE__).'/../../img/os/'.(int)($orderState->id).'.gif');
			
			Configuration::updateValue('GC_INVOICE_OS', (int)($orderState->id));
			
		}
		
		return true;
		
	}

	public function uninstall()
	{
		if (!Configuration::deleteByName('GC_INVOICE_MAX_VALUE') or !parent::uninstall())
			return false;
		return true;
	}
	
	/*
	*	Hooks
	*/
	
	public function hookPayment($params) {
		
		if (!$this->active)
			return ;

		global $smarty;

		$smarty->assign(array(
			'this_path' => $this->_path,
			'this_path_ssl' => Tools::getShopDomainSsl(true, true).__PS_BASE_URI__.'modules/'.$this->name.'/'
		));
		
		return $this->display(__FILE__, 'payment.tpl');
		
	}

	public function hookPaymentReturn($params) {
		
		if (!$this->active)
			return ;

		global $smarty;
		
		$state = $params['objOrder']->getCurrentState();
		
		if ($state == Configuration::get('GC_INVOICE_OS') OR $state == _PS_OS_OUTOFSTOCK_) {
			
			$smarty->assign(array(
				'total_to_pay' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false, false),
				'maxInvoiceValue' => $this->maxInvoiceValue,
				'status' => 'ok',
				'id_order' => $params['objOrder']->id
			));
		}
		else {
			$smarty->assign('status', 'failed');
		}
		
		return $this->display(__FILE__, 'payment_return.tpl');
		
	}
	
	/*
	*	Custom Functions
	*/
	
	/*
	*	Admin integration
	*/
	
	public function getContent() {
		
		$html = '<h2>'.$this->displayName.'</h2>';

		$html .= $this->_postProcess();
		$html .= $this->_displayForm();

		return $html;
		
	}
	
	private function _postProcess() {
		
		if (isset($_POST['btnSubmit'])) {
			
			Configuration::updateValue('GC_INVOICE_MAX_VALUE', $_POST['maxInvoiceValue']);
			
		}
		
		return '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" /> '.$this->l('Settings updated').'</div>';
		
	}
	
	private function _displayForm() {
		
		return
		'<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
			<legend>'.$this->l('Invoice details').'</legend>
				<table border="0" cellpadding="0" cellspacing="0" id="form">
					<tr><td colspan="2">'.$this->l('Please specify the invoice max value for orders').'.<br /><br /></td></tr>
					<tr><td width="130" style="height: 35px;">'.$this->l('Max invoice value').'</td><td><input type="text" name="maxInvoiceValue" value="'.htmlentities(Tools::getValue('maxInvoiceValue', Configuration::get('GC_MAX_INVOICE_VALUE')), ENT_COMPAT, 'UTF-8').'" style="width: 300px;" /></td></tr>
					
					<tr><td colspan="2" align="center"><input class="button" name="btnSubmit" value="'.$this->l('Update settings').'" type="submit" /></td></tr>
				</table>
			</fieldset>
		</form>';
		
	}
	
}
